#ifndef __SERVERTOOLS_H__
#define __SERVERTOOLS_H__
/*------------------------------------------------------------------------
  **** BEGIN LICENSE BLOCK ****
  Version: MPL 1.1/GPL 2.0/LGPL 2.1
  Copyright(c) 2004-2010 Created by Eric Fredericksen (www.pttpsystems.com)
  All Rights Reserved.

  This program are subject to the Mozilla Public License Version
  1.1 (the "License"); you may not use this file except in compliance with
  the License. You may obtain a copy of the License at
  http://www.mozilla.org/MPL/

  This program is free software. Software distributed under the License
  is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
  either express or implied. See the License for the specific language
  governing rights and limitations under the License.

  Alternatively, the contents of this file may be used under the terms of
  either the GNU General Public License Version 2 or later (the "GPL"), or
  the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
  in which case the provisions of the GPL or the LGPL are applicable instead
  of those above. If you wish to allow use of your version of this file only
  under the terms of either the GPL or the LGPL, and not to allow others to
  use your version of this file under the terms of the MPL, indicate your
  decision by deleting the provisions above and replace them with the notice
  and other provisions required by the GPL or the LGPL. If you do not delete
  the provisions above, a recipient may use your version of this file under
  the terms of any one of the MPL, the GPL or the LGPL.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
  **** END LICENSE BLOCK ****
------------------------------------------------------------------------*/

#include <WinSock2.h>

//==================================================
//
//==================================================
class CServer
{
public:

	enum
	{
		DEFAULT_LISTEN_IP			= INADDR_ANY, // all interfaces
		DEFAULT_LISTEN_PORT			= 10000,
		DEFAULT_SOCKET_TIMEOUT_ms	= 8000,
		DEFAULT_CONNECTION_QUEUE	= 5
	};

protected:
	bool m_bWSAInitialized;
	bool m_bSocketInitialized;
	WSADATA m_oWSAData;

	void SetListenAddress(DWORD _dwHBO_IP, USHORT _HBO_Port);
	sockaddr_in m_oListenAddress;

	SOCKET m_sListenSocket;

	bool InitWSA(void);

	void PrintWSALastError(void);

public:

	CServer(void);
	virtual ~CServer();

	bool InitSuccess(void) { return( m_bWSAInitialized && m_bSocketInitialized ); }

	// return default interface IP in host byte order
	DWORD DefaultIP(void);
	const char * DefaultDottedIP(void);
	const char * DottedIP(DWORD _HBO_IP);


	// parms in host byte order
	bool BindTo(
		DWORD _dwHBO_IP, 
		USHORT _HBO_Port, 
		USHORT _usMaxWaitingConnections=DEFAULT_CONNECTION_QUEUE
		);

	// never returns! call from thread that knows this
	// calls DispatchConnection upon successful accept() call
	void StartListening(void);

	// override this to do the work in your derived class
	virtual void DispatchConnection(SOCKET _sWorkSocket)
	{
		// just say no
		shutdown(_sWorkSocket, SD_BOTH);
		Sleep(1000);
		closesocket(_sWorkSocket);
	}

};




#endif // __SERVERTOOLS_H__
